/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_7923;
import slimeknights.mantle.client.book.data.element.IDataElement;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;

public class IngredientData
implements IDataElement {
    public SizedIngredient[] ingredients = new SizedIngredient[0];
    public String action;
    private transient String error;
    private transient class_2371<class_1799> items;
    private transient boolean customData;

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public static IngredientData getItemStackData(class_1799 stack) {
        IngredientData data = new IngredientData();
        data.items = class_2371.method_10213((int)1, (Object)stack);
        data.customData = true;
        return data;
    }

    public static IngredientData getItemStackData(class_2371<class_1799> items) {
        IngredientData data = new IngredientData();
        data.items = items;
        data.customData = true;
        return data;
    }

    @Override
    public void load(BookRepository source) {
        if (this.customData) {
            return;
        }
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (SizedIngredient ingredient : this.ingredients) {
            if (ingredient == null) continue;
            stacks.addAll(ingredient.getMatchingStacks());
        }
        if (this.ingredients == null || stacks.isEmpty() || !class_3544.method_15438((String)this.error)) {
            this.items = class_2371.method_10213((int)1, (Object)this.getMissingItem());
            return;
        }
        this.items = class_2371.method_10212((Object)this.getMissingItem(), (Object[])stacks.toArray(new class_1799[0]));
    }

    private class_1799 getMissingItem() {
        return this.getMissingItem(this.error);
    }

    private class_1799 getMissingItem(String error) {
        class_1799 missingItem = new class_1799((class_1935)class_1802.field_8077);
        class_2487 display = missingItem.method_7911("display");
        display.method_10582("Name", "\u00a7rError Loading Item");
        class_2499 lore = new class_2499();
        if (!class_3544.method_15438((String)error)) {
            lore.add((Object)class_2519.method_23256((String)"\u00a7r\u00a7eError:"));
            lore.add((Object)class_2519.method_23256((String)("\u00a7r\u00a7e" + error)));
        }
        display.method_10566("Lore", (class_2520)lore);
        return missingItem;
    }

    public static class Deserializer
    implements JsonDeserializer<IngredientData> {
        public IngredientData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonPrimitive primitive;
            JsonElement action;
            JsonObject object;
            IngredientData data = new IngredientData();
            if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                data.ingredients = new SizedIngredient[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    try {
                        data.ingredients[i] = this.readIngredient(array.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        data.ingredients[i] = SizedIngredient.of(class_1856.method_8101((class_1799[])new class_1799[]{data.getMissingItem(e.getMessage())}));
                    }
                }
                return data;
            }
            try {
                data.ingredients = new SizedIngredient[]{this.readIngredient(json)};
            }
            catch (Exception e) {
                data.error = e.getMessage();
                return data;
            }
            if (json.isJsonObject() && (object = json.getAsJsonObject()).has("action") && (action = object.get("action")).isJsonPrimitive() && (primitive = action.getAsJsonPrimitive()).isString()) {
                data.action = primitive.getAsString();
            }
            return data;
        }

        private SizedIngredient readIngredient(JsonElement json) {
            JsonPrimitive primitive;
            if (json.isJsonPrimitive() && (primitive = json.getAsJsonPrimitive()).isString()) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(primitive.getAsString()));
                return SizedIngredient.fromItems(new class_1935[]{item});
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("Must be an array, string or JSON object");
            }
            JsonObject object = json.getAsJsonObject();
            return SizedIngredient.deserialize(object);
        }
    }
}

